<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://www.mf.gov.pl/SENT/2017/12/08/SENT_500.xsd"
                xmlns:tp="http://www.mf.gov.pl/SENT/2017/12/08/STypes.xsd">
  <xsl:template match="ns1:SENT_500">
    <!-- TODO: Auto-generated template -->
    <html>
      <head>
        <script>
          //<![CDATA[
					// Module
				var languative;
				(function (languative) {
				    var phraseIdAttr = "data-phrase-id";

				    languative.ignoreTags = {
				        img: "<img />",
				        br: "<br />",
				        hr: "<hr />"
				    };

				    languative.dictonaries = {
				        html: {
				            _id: "en",
				            _name: "English"
				        },

				        pl: {
				            _id: "pl",
				            _name: "Polski - Polish"
				        },

				        en: {
				            _id: "en",
				            _name: "English"
				        }
				    };

				    languative.selectedDictionary = null;

				    function getDictionary(langKey) {
				        langKey = langKey.toLowerCase();
				        if (langKey in languative.dictonaries)
				            return languative.dictonaries[langKey];
				            else
				            return languative.dictonaries["pl"];

				        // Dictionary at key "pl-PL" not found, so keep looking for key "pl"
				        var sep = langKey.indexOf("-");
				        if (sep > 0)
				            langKey = langKey.substring(0, sep);
				        return languative.dictonaries[langKey];
				    }
				    languative.getDictionary = getDictionary;

				    function getPhrase(phraseId) {
				        var res = findPhrase(phraseId);
				        if (res)
				            return res; else
				            return phraseId;
				    }
				    languative.getPhrase = getPhrase;

				    function findPhrase(phraseId) {
				        if ((phraseId == null) || (phraseId == ""))
				            return null;

				        if ((languative.selectedDictionary != null) && (phraseId in languative.selectedDictionary))
				            return languative.selectedDictionary[phraseId];
				        if (phraseId in languative.dictonaries.html)
				            return languative.dictonaries.html[phraseId];

				        return null;
				    }
				    languative.findPhrase = findPhrase;

				    function getYesNo(value) {
				        if (value === undefined)
				            return getPhrase("undefined"); else if (value)
				            return getPhrase("yes"); else
				            return getPhrase("no");
				    }
				    languative.getYesNo = getYesNo;

				    //IE8 Tweak
				    function getAttr(node, attr) {
				        var result = (node.getAttribute && node.getAttribute(attr)) || null;
				        if (!result && node.attributes) {
				            for (var i = 0; i < node.attributes.length; i++) {
				                var attrNode = node.attributes[i];
				                if (attrNode.nodeName === attr)
				                    return attrNode.nodeValue;
				            }
				        }
				        return result;
				    }

				    function changeLanguage(langKey) {
				        function setTagPhrase(tag, phrase) {
				            if (tag.childNodes.length > 1) {
				                for (var ci = 0; ci < tag.childNodes.length; ci++) {
				                    var chNode = tag.childNodes[ci];
				                    var nName = chNode.nodeName.toLowerCase();
				                    if (!(nName in languative.ignoreTags)) {
				                        if ("innerHTML" in chNode) {
				                            chNode["innerHTML"] = " " + phrase[ci] + " ";
				                        } else {
				                            chNode.nodeValue = " " + phrase[ci] + " ";
				                        }
				                    }
				                }
				            } else {
				                tag.innerHTML = " " + phrase + " ";
				            }
				        }

				        //return;
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            console.warn("Cannot identify dictionary by key '" + langKey + "'. Default dictionary (" + languative.dictonaries.html._id + ": " + languative.dictonaries.html._name + ") used instead.");
				            langDict = languative.dictonaries.html;
				        }
				        languative.selectedDictionary = langDict;

				        var tags = getHtmlTags();
				        for (var ti = 0; ti < tags.length; ti++) {
				            var tag = tags[ti];
				            var phraseId = getAttr(tag, phraseIdAttr);
				            if ((phraseId != null)) {
				                var phraseValue = languative.getPhrase(phraseId);
				                if (phraseValue) {
				                    setTagPhrase(tag, phraseValue);
				                } else {
				                    console.warn("Phrase not definied in dictionary: data-phrase-id='" + phraseId + "'");
				                }
				            }
				        }

				        if (langDict["Title"] != null) {
				            document.title = langDict["Title"];
				        }
				    }
				    languative.changeLanguage = changeLanguage;

				    function getHtmlTags() {
				        var res = new Array();
				        var docTags = document.body.getElementsByTagName("*");

				        for (var i = 0; i < docTags.length; i++) {
				            var docTag = docTags[i];
				            var phraseId = getAttr(docTag, phraseIdAttr);
				            if (phraseId)
				                res.push(docTag);
				        }
				        return res;
				    }

				    var initialized = false;

				    function init() {
				        if (!initialized) {
				            initialized = true;
				            var htmlDict = languative.dictonaries.en;

				            for (var dictKey in htmlDict) {
				                if (!(dictKey in languative.dictonaries.html)) {
				                    languative.dictonaries.html[dictKey] = htmlDict[dictKey];
				                }
				            }
				            var nav = window.navigator;
				            languative.changeLanguage(nav.userLanguage || nav.language);
				        }
				    }
				    languative.init = init;

				    function modifyDictionary(langKey, dictModifications) {
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            languative.dictonaries[langKey.toLowerCase()] = dictModifications;
				        } else {
				            for (var dictKey in dictModifications) {
				                langDict[dictKey] = dictModifications[dictKey];
				            }
				        }
				    }
				    languative.modifyDictionary = modifyDictionary;
				})(languative || (languative = {}));

				if (document.addEventListener)
				    document.addEventListener('DOMContentLoaded', languative.init);

				if (window.addEventListener) {
				    window.addEventListener('load', languative.init, false);
				} else {
				    window.attachEvent('onload', languative.init);
				}
				<!-- sourceMappingURL=languative.js.map -->

				languative.modifyDictionary("html", {
            		githubLink: "Fork me on GitHub"
        		});

languative.modifyDictionary("pl", {
sent500: "SENT500 - POTWIERDZENIE AKTUALIZACJI, ANULOWANIA, ZAMKNIĘCIA ZGŁOSZENIA PRZEWOZU ALBO INFORMACJA O PRZYCZYNACH ODRZUCENIA ZGŁOSZENIA",
selectLanguage: "Wybierz język:",
english: "English",
polish: "Polski",
sentNumber: "NUMER REFERENCYJNY ZGŁOSZENIA:",
sentChecksumOfDocument: "Suma kontrolna dokumentu podana w formacie SHA-1:",
sentCodeOfMessage: "Kod komunikatu/błędu:",
sentCreationDate: "Data rejestracji:",
sentCreator: "Użytkownik rejestrujący:",
sentIdSent: "SENT ID:",
sentIncomingNumber: "Numer wpływu:",
sentListOfMessages: "Lista z informacjami o operacji lub błędach w walidacji zgłoszenia",
sentMessage: "Treść komunikatu/błędu:",
sentTypeOfNotification: "Typ komunikatu:",
sentTypeOfNotification0: "Informacja o błędzie",
sentTypeOfNotification1: "Informacja o poprawnym wykonaniu operacji",
sentTypeOfRegistry: "Rodzaj rejestru źródłowego:",
sentNumberInRegistry: "Numer zgłoszenia przewozu:",
sentOrganisationName: "Podmiot:",
sentSourceDocumentID: "Numer własny zgłoszenia:",
sentSourceDocumentInfo: "Dane komunikatu, którego dotyczy niniejsze potwierdzenie lub informacja",
sentSystemInfo: "Informacje systemowe",
sentSystemName: "System:",
sentTypeOfOperation: "Typ operacji na zgłoszeniu:"
});

languative.modifyDictionary("en", {
sent500: "SENT500 - CONFIRMATION OF THE UPDATE, CANCELLATION, CLOSING OF THE NOTIFICATION OF THE CARRIAGE OF GOODS OR INFORMATION ABOUT THE REASONS FOR THE REJECTION",
selectLanguage: "Select language:",
english: "English",
polish: "Polski",
sentNumber: "CARRIAGE NOTIFICATION NUMBER:",
sentChecksumOfDocument: "Checksum of the document provided in the SHA-1 format:",
sentCodeOfMessage: "Message/error code:",
sentCreationDate: "Creation date:",
sentCreator: "User registering:",
sentIdSent: "SENT ID:",
sentIncomingNumber: "Incoming number:",
sentListOfMessages: "List of information on the operation or errors in notification validation",
sentMessage: "Message/error text:",
sentTypeOfNotification: "Type of notification:",
sentTypeOfNotification0: "Information on errors",
sentTypeOfNotification1: "Information on valid operation",
sentTypeOfRegistry: "Type of source registry:",
sentNumberInRegistry: "Carriage notification number:",
sentOrganisationName: "Entity:",
sentSourceDocumentID: "Own number of the notification:",
sentSourceDocumentInfo: "Data of the notification this confirmation or information refers to",
sentSystemInfo: "System information",
sentSystemName: "System:",
sentTypeOfOperation: "Operation type on the notification:"
});

function loadHtmlDictionary() {
document.getElementById("htmlDictionary").innerText = JSON.stringify(languative.dictonaries.html, null, "  ");
}

function loadActiveDictionary() {
document.getElementById("activeDictionary").innerText = JSON.stringify(languative.getDictionaryFromHtml(), null, "  ");
}

//]]>
        </script>
        <style>
          * {
          -webkit-print-color-adjust: exact !important;
          color-adjust: exact !important;
          }

          @media print {
          body {-webkit-print-color-adjust: exact;}
          }

          body {
          font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
          margin: 0 auto;
          padding: 0 auto;
          }

          .sent-xslt .h2 {
          padding: 15px 4px 15px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#FA8072;
          font-weight: bold;
          font-size: 12px;
          margin-bottom: 0;
          border: 2px solid red;
          }

          .sent-xslt .h3 {
          padding: 15px 4px 15px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#98FB98;
          font-weight: bold;
          font-size: 12px;
          margin-bottom: 0;
          border: 2px solid green;
          }

          .sent-xslt .s1 {
          border: 1px solid #c8c9ca;
          max-width: 1220px;
          }

          .sent-xslt .t1 {
          padding: 2px 5px;
          position: relative;
          display: table;
          width: 100%;
          }

          .sent-xslt .grupName {
          font-size: 12px;
          margin: -15px 5px 0 -5px;
          font-weight: bold;
          <!-- display:block; -->
          display:flex;
          color: #000000;
          background-color:#dbddde;
          padding:5px 5px 5px 10px;
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .element-1 {
          font-size: 12px;
          font-weight: normal;
          }

          .sent-xslt .grupInfo p {
          margin: 1px 0 1px 10px;
          font-weight: bold;
          font-size: 12px;
          }

          .sent-xslt .grupInfoSent {
          min-height: 40px;
          <!-- border-bottom: 1px solid #c8c9ca; -->
          margin: 6px 5px 4px -5px;
          }

          .sent-xslt .grupInfoSent p {
          margin: -2px 0 1px 10px;
          font-size: 16px;
          font-weight: bold;
          }

          .sent-xslt .sent {
          font-size: 12px;
          font-weight: normal;
          }

          .sent-xslt .grupInfo {
          margin: 0 5px 0 -5px;
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .info1 {
          width: 50%;
          float: left;
          display: table-cell;
          padding-bottom: 12px;
          }

          .sent-xslt .info3a {
          width: 33%;
          float: left;
          display: table-cell;
          padding-bottom: 10px;
          }

          .sent-xslt .lang ul {
          margin: 0 auto;
          padding: 0;
          }

          .sent-xslt .lang ul li {
          display: inline;
          margin-left: 10px;
          }

          }
        </style>
      </head>
      <body onLoad="languative.changeLanguage('pl');">
        <div class="sent-xslt">
          <section class="sent-xslt s1">
            <div class="sent-xslt lang">
              <ul>
                <li>
                  <span class="sent-xslt element-1" data-phrase-id="selectLanguage"></span>
                </li>
                <li>
                  <span class="sent-xslt element-1">
                    <a href="#" onclick="languative.changeLanguage('en');">
                      <img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAB6ElEQVQoz2OYNHPfjqtvqqcfS2kGosOJjQdu3n27NrlxTUIdkOGZvc0jbYdtzIaoxp1zAvOr5x5lWLLi1P+Nq/79+3/74ZdFG27PX38HyP4/ped/XyuQMWnh5d65F06eePyvq+bf358TNl1gSGo5uOfku/9Ll/8/uPf///9t064Cyf+pmf8TEoF0Sd+lL4vWfO/uBrLnrbokaTIDpGHhhrt1E68+3Hf/T1P9fwiIifkfHgFi5Gb+f/Hiwp23jp7Li5qOCOpOZAA6FOQGNBAa+t/PD00MqOzMtZcMaxJr/0/u+J+S8j8+/n9k5P+QEJBSH59/rq6/7O1/Wlp+NzH5qqf3VVv7Z7Bbq7wVDhtsbf+YWUDMBeK/f//++fvn958/J6++YLCP29Qz53xU2o4rV9//f/vmZ3I8SJWRyW99Q7CGv0+dHPfP3CohPSskYT2DcDaDedi6xetBIfO5se5DV1dMyTEg+4+27i9NbaCrreyX/Pz//8usuS8SYpqmnmMQTGeYvPnyv39/v7dXHD1wu7DhYF7DYaAL/4Z4/A5y/vf3b3jattC41dsP3/r758frBN/soiUMVfMOTHFJds5cJKgzh0djMofqhPPXXrRKW7SIm5y+8pJBvJhBtIBBOFfEsK53z3VX0zwAPExoqi63l4YAAAAASUVORK5CYII='/>
                    </a>
                  </span>
                </li>
                <li>
                  <span class="sent-xslt element-1">
                    <a href="#" onclick="languative.changeLanguage('pl');">
                      <img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAMAAABBPP0LAAAAhFBMVEXDAADKAADVAQHX19faAADd3d3jDQ3k5eXlExPmGRnnLi7oHx/oMjLoNjbpJCTqKirq6urrLi7sLy/sOzrsRETtNDTtS0vuUFDu7u7vi4vvmZnwVlfwj4/xlJTy8vL0m5v19fX29vb39/f4+Pj5+fn6+vr7+/v8/Pz9/f39/f7+/v7///9BfFeGAAAAXUlEQVQIHQXB0W1CMRRAMecRpI7BZ/dfiRWQqBC5p/Z6wPDhz5t1+xWVqp4bq1FVLRuWqioucKuqNPu8AKNjtb3AdU5nuncB1zmdSTa4vtOZxrT94Hsf+TQstkEQ/8uqTs/uhVeSAAAAAElFTkSuQmCC'/>
                    </a>
                  </span>
                </li>
              </ul>
            </div>
            <xsl:choose>
              <xsl:when test="ns1:TypeOfNotification = '1'">
                <p data-phrase-id="sent500" class="sent-xslt h3"></p>
              </xsl:when>
              <xsl:otherwise>
                <p data-phrase-id="sent500" class="sent-xslt h2"></p>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="ns1:SentNumber != ''">
              <div class="sent-xslt t1">
                <div class="sent-xslt grupInfoSent">
                  <div class="sent-xslt info1">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentNumber"></span>
                      <br/>
                      <xsl:value-of select="ns1:SentNumber"/>
                    </p>
                  </div>
                </div>
              </div>
            </xsl:if>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName" data-phrase-id="sentSystemInfo"></p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1 sent" data-phrase-id="sentOrganisationName"></span>
                    <xsl:value-of select="ns1:SystemInfo/tp:OrganisationName"/>
                  </p>
                </div>
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1 sent" data-phrase-id="sentSystemName"></span>
                    <xsl:value-of select="ns1:SystemInfo/tp:SystemName"/>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName" data-phrase-id="sentSourceDocumentInfo"></p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info3a">
                  <xsl:if test="ns1:SourceDocumentInfo/tp:CreationDate != ''">
                    <xsl:variable name="creDate" select="substring-before(ns1:SourceDocumentInfo/tp:CreationDate, 'T')"/>
                    <xsl:variable name="creTime" select="substring(ns1:SourceDocumentInfo/tp:CreationDate, 12,8)"/>
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentCreationDate"></span>
                      <xsl:value-of select="$creDate"/> godz.<xsl:value-of select="$creTime"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="ns1:SourceDocumentInfo/tp:Creator != ''">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentCreator"></span>
                      <xsl:value-of select="ns1:SourceDocumentInfo/tp:Creator"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="ns1:SourceDocumentInfo/tp:SentId != ''">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentIdSent"></span>
                      <xsl:value-of select="ns1:SourceDocumentInfo/tp:SentId"/>
                    </p>
                  </xsl:if>
                </div>
                <div class="sent-xslt info3a">
                  <xsl:if test="ns1:SourceDocumentInfo/tp:SourceDocumentId != ''">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentSourceDocumentID"></span>
                      <xsl:value-of select="ns1:SourceDocumentInfo/tp:SourceDocumentId"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="ns1:SourceDocumentInfo/tp:ChecksumOfDocument != ''">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentChecksumOfDocument"></span>
                      <xsl:value-of select="ns1:SourceDocumentInfo/tp:ChecksumOfDocument"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="ns1:SourceDocumentInfo/tp:IncomingNumber != ''">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentIncomingNumber"></span>
                      <xsl:value-of select="ns1:SourceDocumentInfo/tp:IncomingNumber"/>
                    </p>
                  </xsl:if>
                </div>
                <div class="sent-xslt info3a">
                  <xsl:if test="ns1:TypeOfNotification != ''">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentTypeOfNotification"></span>
                      <xsl:choose>
                        <xsl:when test="ns1:TypeOfNotification = '0'">
                          <span data-phrase-id="sentTypeOfNotification0"></span>
                        </xsl:when>
                        <xsl:when test="ns1:TypeOfNotification = '1'">
                          <span data-phrase-id="sentTypeOfNotification1"></span>
                        </xsl:when>
                      </xsl:choose>
                    </p>
                  </xsl:if>
                  <xsl:if test="ns1:TypeOfRegistry != ''">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentTypeOfRegistry"></span>
                      <xsl:value-of select="ns1:TypeOfRegistry"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="ns1:NumberInRegistry != ''">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentNumberInRegistry"></span>
                      <xsl:value-of select="ns1:NumberInRegistry"/>
                    </p>
                  </xsl:if>
                </div>
              </div>
            </div>
            <xsl:if test="ns1:ListOfMessages != ''">
              <div class="sent-xslt t1">
                <p class="sent-xslt grupName" data-phrase-id="sentListOfMessages"></p>
                <div class="sent-xslt grupInfo">
                  <xsl:if test="ns1:ListOfMessages/tp:TypeOfOperation != ''">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentTypeOfOperation"></span>
                      <xsl:value-of select="ns1:ListOfMessages/tp:TypeOfOperation"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="ns1:ListOfMessages/tp:CodeOfMessage != ''">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentCodeOfMessage"></span>
                      <xsl:value-of select="ns1:ListOfMessages/tp:CodeOfMessage"/>
                    </p>
                  </xsl:if>
                  <xsl:if test="ns1:ListOfMessages/tp:Message != ''">
                    <p>
                      <span class="sent-xslt element-1 sent" data-phrase-id="sentMessage"></span>
                      <xsl:value-of select="ns1:ListOfMessages/tp:Message"/>
                    </p>
                  </xsl:if>
                </div>
              </div>
            </xsl:if>
          </section>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
